<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\Importers\InspeccionKoboImporter;

class ImportKoboInspecciones extends Command
{
    protected $signature = 'kobo:import-inspecciones';
    protected $description = 'Importar inspecciones desde KoboToolbox a MongoDB';

    public function handle(InspeccionKoboImporter $importer)
    {
        $this->info('Iniciando importación desde KoboToolbox...');
        
        try {
            $stats = $importer->import();
            
            $this->info("Importación completada:");
            $this->info("Total de registros: {$stats['total']}");
            $this->info("Importados exitosamente: {$stats['imported']}");
            $this->info("Fallidos: {$stats['failed']}");
            
            if ($stats['failed'] > 0) {
                $this->warn("Errores encontrados:");
                foreach ($stats['errors'] as $error) {
                    $this->error("Record: {$error['record']} - Error: {$error['error']}");
                }
            }
            
            return Command::SUCCESS;
        } catch (\Exception $e) {
            $this->error("Error en la importación: " . $e->getMessage());
            return Command::FAILURE;
        }
    }
}