<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class TestMongoConnection extends Command
{
    protected $signature = 'mongo:test';
    protected $description = 'Probar conexión a MongoDB';

    public function handle()
    {
        try {
            $this->info('Probando conexión a MongoDB...');
            
            // Intentar conectar
            DB::connection('mongodb')->getMongoDB()->command(['ping' => 1]);
            
            $this->info('✅ Conexión exitosa a MongoDB');
            
            // Listar colecciones
            $collections = DB::connection('mongodb')->getMongoDB()->listCollections();
            $this->info('Colecciones disponibles:');
            foreach ($collections as $collection) {
                $this->line('  - ' . $collection->getName());
            }
            
            return Command::SUCCESS;
            
        } catch (\Exception $e) {
            $this->error('❌ Error de conexión: ' . $e->getMessage());
            return Command::FAILURE;
        }
    }
}