<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class VerificarGeoreferenciacion extends Command
{
    protected $signature = 'georef:verificar {year=2025}';
    protected $description = 'Verifica qué _id no se insertaron en la tabla georeferencings';

    public function handle()
    {
        $year = $this->argument('year');

        // 1. Obtener los datos desde la API (ajusta la URL con la de tu KoBo

        $url = "https://eu.kobotoolbox.org/api/v2/assets/aRAgXziySHvDTArgGpt6zD/data/?format=json";
        $response = Http::get($url);

        if (!$response->successful()) {
            $this->error("Error al consultar API");
            return;
        }

        $apiData = $response->json();
        $idsApi = collect($apiData['results'])->pluck('_id')->map(fn($v) => (string) $v);

        $this->info("Total en API: " . $idsApi->count());

        // 2. Obtener los _id desde la base de datos
        $idsDb = DB::table('georeferencings')
            ->where('version', $year)
            ->pluck('_id')
            ->map(fn($v) => (string) $v);

        $this->info("Total en DB: " . $idsDb->count());

        // 3. Diferencia: cuáles están en API y no en DB
        $faltantes = $idsApi->diff($idsDb);

        if ($faltantes->isEmpty()) {
            $this->info("✅ Todos los registros fueron insertados");
        } else {
            $this->warn("⚠️ Faltan " . $faltantes->count() . " registros:");
            foreach ($faltantes as $id) {
                $this->line(" - _id: " . $id);
            }
        }
    }
}