<?php

// app/Http/Controllers/ImportacionController.php

namespace App\Http\Controllers;

use App\Services\ImportadorGeoreferenciaciones;
use App\Services\ImportadorParcelas;
use App\Services\ImportadorProductores;
use Illuminate\Http\Request;

class ImportacionController extends Controller
{
    public function importarTodo(Request $request)
    {
        $year = $request->input('year', date('Y'));
        
        // Importar en el orden correcto para respetar relaciones
        $importadores = [
            'productores' => new ImportadorProductores($year),
            'parcelas' => new ImportadorParcelas($year),
            'georeferenciaciones' => new ImportadorGeoreferenciaciones($year),
        ];
        
        $resultados = [];
        
        foreach ($importadores as $tipo => $importador) {
            $resultados[$tipo] = $importador->importar() ? 'éxito' : 'fallo';
        }
        
        return response()->json([
            'message' => 'Proceso de importación completado',
            'resultados' => $resultados,
            'year' => $year
        ]);
    }

    public function importarProductores(Request $request)
    {
        $year = $request->input('year', date('Y'));
        $importador = new ImportadorProductores($year);
        
        return response()->json([
            'success' => $importador->importar(),
            'message' => 'Importación de productores completada',
            'year' => $year
        ]);
    }

    public function importarParcelas(Request $request)
    {
        $year = $request->input('year', date('Y'));
        $importador = new ImportadorParcelas($year);
        
        return response()->json([
            'success' => $importador->importar(),
            'message' => 'Importación de parcelas completada',
            'year' => $year
        ]);
    }

    public function importarGeoreferenciaciones(Request $request)
    {
        $year = $request->input('year', date('Y'));
        $importador = new ImportadorGeoreferenciaciones($year);
        
        return response()->json([
            'success' => $importador->importar(),
            'message' => 'Importación de georeferenciaciones completada',
            'year' => $year
        ]);
    }
}