<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Abonera extends Model
{
    use HasFactory;

    protected $table = 'aboneras';

    protected $fillable = [
        'internal_inspection_id',
        'abonera_p1_abono_organico',
        'abonera_p1_tipo_abono_organico',
        'abonera_p1_foto_abono_organico',
        'abonera_p1_plantas_abono_organico',
        'abonera_p1_kilos_litros_abono_composta',
        'abonera_p1_kilos_planta_composta',
        'abonera_p1_cuantos_litros_lixiviado_lombricomposta',
        'abonera_p1_plantas_foliar_lombricomposta',
        'abonera_p1_donde_aplico_composta',
        'abonera_p1_composta_vivero',
        'abonera_p1_composta_vivero_bolsas',
        'abonera_p1_compra_abono_organico',
        'abonera_p1_compra_abono_cumplimiento',
        'abonera_p1_cosecha_abono',
        'abonera_p1_plantas_abonadas',
        'abonera_p1_aplica_estiercol_crudo',
        'abonera_p1_estiercol_crudo_plantas',
        'abonera_p1_estiercol_crudo_kg',
    ];

    protected $casts = [
        'abonera_p1_plantas_abono_organico' => 'decimal:2',
        'abonera_p1_kilos_litros_abono_composta' => 'decimal:2',
        'abonera_p1_kilos_planta_composta' => 'decimal:2',
        'abonera_p1_cuantos_litros_lixiviado_lombricomposta' => 'decimal:2',
        'abonera_p1_plantas_foliar_lombricomposta' => 'decimal:2',
        'abonera_p1_composta_vivero_bolsas' => 'integer',
        'abonera_p1_cosecha_abono' => 'decimal:2',
        'abonera_p1_plantas_abonadas' => 'integer',
        'abonera_p1_estiercol_crudo_plantas' => 'integer',
        'abonera_p1_estiercol_crudo_kg' => 'decimal:2',
    ];

    // Relación con internal_inspection
    public function internalInspection()
    {
        return $this->belongsTo(InternalInspection::class, 'internal_inspection_id');
    }
}
