<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;


class CoffeeParcelRegistry extends Model
{
    use HasFactory;

    protected $fillable = [
        '_id',
        // Información del formulario
        'starttime',
        'endtime',
        'today',
        'deviceid',
        'usuario',
        'numero_telefono',

        // Información del socio
        'id_record',
        'codigo_socio',
        'socio',

        // Información de la parcela
        'nombre_parcela',
        'n_parcela',
        'id_parcela',

        'ciclo',
        'superficie',

         // Terrenos colindantes
        'norte',
        'norte_propietario',
        'sur',
        'sur_propietario',
        'este',
        'este_propietario',
        'oeste',
        'oeste_propietario',

        // Metadatos
        'meta_instanceID',
        'meta_rootUuid',
        'meta_instanceName',
        'meta_deprecatedID',

        '__version__',
        'formhub_uuid',
        '_xform_id_string',
        '_uuid',
        // Información de envío
        '_status',
        '_submission_time',
        '_submitted_by',
        
        'version',
    ];

     protected $casts = [
        'starttime' => 'datetime',
        'endtime' => 'datetime',
        'today' => 'date',
        'superficie' => 'decimal:2',
        '_submission_time' => 'datetime',
    ];
    
    public function productor()
    {
        return $this->belongsTo(Producer::class, 'codigo_socio', 'id_productor');
    }
    public function georefrenciacion()
    {
        return $this->hasOne(Georeferencing::class, 'codigo_parcela', 'id_parcela');
    }
    public function terrenosColindantes()
    {
        return $this->hasMany(TerrenoColindante::class, 'id_parcela', 'id_parcela');
    }
    // Agregar en el modelo Parcela
    public function cosechasAcopio()
    {
        return $this->hasMany(CosechaAcopio::class, 'parcela_id');
    }

    //  public function inspecciones()
    // {
    //     return $this->hasMany(Inspeccion::class, 'codigo_parcela', 'id_parcela');
    // }

    public function scopeVersion($query, $year)
    {
        return $query->where('version', $year);
    }
}
