<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Georeferencing extends Model
{
    use HasFactory;
    protected $table = 'georeferencings';

    protected $fillable = [
        '_id',
        'start',
        'end',
        'today',

        'username',
        'deviceid',
        'phonenumber',
        'hora',
        'horas',
        'minutos',
        'segundos',
        'anos',
        'mes',
        'dias',

        'id_record',
        'promotor',
        'dni',
        'socio',
        'localidad',
        'municipio',
        'numero_parcela',
        'codigo_parcela',
        'nombre_parcela',
        'anio_incio_cultivo',
        'gps',
        'poligono',
        'area_gps',
        'area_gps_ha',

        'area_gps_display',
        'meta_instanceID',
        'meta_rootUuid',
        'meta_instanceName',

        'starttime',
        'endtime',
        'p_nombre',
        'ciclo_codigo',
        'subscriberid',
        'simid',
        'formhub_uuid',
        '__version__',
        '_xform_id_string',
        '_uuid',
        '_attachments',
        '_status',
        '_geolocation',
        
        '_submission_time',
        '_tags',
        '_notes',
        '_validation_status',
        '_submitted_by',
        'version'
    ];

    protected $casts = [
        'start' => 'datetime',
        'end' => 'datetime',
        'today' => 'date',
        'anio_incio_cultivo' => 'date',
        'area_gps' => 'decimal:2',
        'area_gps_ha' => 'decimal:2',
        '_submission_time' => 'datetime',
    ];

    public function parcela()
    {
        return $this->belongsTo(CoffeeParcelRegistry::class, 'codigo_parcela', 'id_parcela');
    }

    public function scopeVersion($query, $year)
    {
        return $query->where('version', $year);
    }
    public function producer()
    {
        return $this->belongsTo(\App\Models\Producer::class, 'dni', 'id_productor');
    }

    
}


// modelo de inspección:

// // app/Models/Inspeccion.php

// namespace App\Models;

// use Illuminate\Database\Eloquent\Factories\HasFactory;
// use Illuminate\Database\Eloquent\Model;

// class Inspeccion extends Model
// {
//     use HasFactory;

//     protected $table = 'inspecciones';

//     protected $fillable = [
//         'codigo_parcela',
//         // ... otros campos de inspección
//         'version'
//     ];

//     public function parcela()
//     {
//         return $this->belongsTo(Parcela::class, 'codigo_parcela', 'id_parcela');
//     }

//     public function scopeVersion($query, $year)
//     {
//         return $query->where('version', $year);
//     }
// }