<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HumanRightsCase extends Model
{
    use HasFactory;

    protected $table = 'human_rights_cases';

    protected $fillable = [
        '_id',
        'formhub_uuid',
        'start',
        'end',

        // Datos del productor
        'nombre_encuestador',
        'dni',
        'dni_o',
        'socio',
        'municipio',
        'localidad',
        'grupo_trabajo',
        'telefono',
        'genero',
        'fecha_nacimiento',

        // Mano de obra
        'contrato_mano_obra',
        'edad_jornaleros',
        'actividad_realizada',
        'actividad_especifica',
        'origen',
        'estado',
        'pais',
        'comunidad',
        'trabajo_forzado',
        'observaciones',

        // Firma
        'firma',

        // Metadata Kobo
        '__version__',
        'instanceID',
        'instanceName',
        '_xform_id_string',
        '_uuid',
        'rootUuid',
        '_attachments',
        '_status',
        '_geolocation',
        '_submission_time',
        '_tags',
        '_notes',
        '_validation_status',
        '_submitted_by',

        'version',
    ];

    protected $casts = [
        'start' => 'datetime',
        'end' => 'datetime',
        'fecha_nacimiento' => 'date',

        'edad_jornaleros' => 'array',
        'actividad_realizada' => 'array',

        '_attachments' => 'array',
        '_geolocation' => 'array',
        '_tags' => 'array',
        '_notes' => 'array',

        'version' => 'integer',
    ];

    public $timestamps = true;
}
