<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use PhpParser\Node\Expr\Cast;

class Producer extends Model
{
    use HasFactory;


    protected $table = 'producers';
    protected $primaryKey = 'id';
    protected $keyType = 'int';
    public $incrementing = true;

    protected $fillable = [
        '_id',
        'id_productor',
        'fecha_importacion',
        'localidad',
        'municipio',
        'region',
        'socio',
        'grupo_trabajo',
        'curp',
        'rfc',
        'ine',
        'folio_cafetalero',
        'folio_suri',
        'fecha_nacimiento',
        'genero',
        'Estatus_actual',
        'estatus',
        'categoria_pasada',
        'ingreso',
        'transicion',
        'numero_parcelas',
        'activo',
        'meta_instanceID',
        'meta_rootUuid',
        'meta_instanceName',
        'meta_deprecatedID',
        '__version__',
        'formhub_uuid',
        '_xform_id_string',
        '_uuid',
        '_status',
        '_submission_time',
        '_submitted_by',
        'version'
    ];

    protected $casts = [
        'fecha_importacion' => 'date',
        'fecha_nacimiento' => 'date',
        'ingreso' => 'date',
        'transicion' => 'date',
        'activo' => 'boolean',
        '_submission_time' => 'datetime',
    ];
    //Metodo para mostrar las fechas en formato serealizado corto:
    protected function serializeDate(\DateTimeInterface $date): string
    {
        return $date->format('Y-m-d');
    }
    
    public function parcelas()
    {
        return $this->hasMany(CoffeeParcelRegistry::class, 'codigo_socio', 'id_productor');
    }

    

    public function scopeVersion($query, $year)
    {
        return $query->where('version', $year);
    }
}
