<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TerrenoColindante extends Model
{
     use HasFactory;

    protected $table = 'terrenos_colindantes';

    protected $fillable = [
        'id_parcela',
        // Colindancias
        'norte',
        'norte_propietario',
        'sur',
        'sur_propietario',
        'este',
        'este_propietario',
        'oeste',
        'oeste_propietario',
        // Riesgos y prevención
        'herbicidas_colindantes',
        'nombre_herbicida_colindante',
        'riesgos_contaminacion',
        'lado_riesgos_contaminacion',
        'franja_amortiguamiento',
        'zanja',
        'barreras_vivas_001',
        'ninguna_evita_contaminacion',
        'glifosato',
        'aplicacion_glifosato',
        'aplicacion_glifosato_metros',
    ];

    protected $casts = [
        'aplicacion_glifosato_metros' => 'integer',
    ];

    /**
     * Relación con CoffeeParcelRegistry
     */
    public function parcela()
    {
        return $this->belongsTo(CoffeeParcelRegistry::class, 'id_parcela', 'id_parcela');
    }
}
