<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'kobotoolbox' => [
    'server_url' => env('KOBO_BASE_URL', 'https://eu.kobotoolbox.org'),
    'auth_method' => env('KOBO_AUTH_METHOD', 'basic'),
    'username' => env('KOBO_USER_NAME'),
    'password' => env('KOBO_PASSWORD'),
    'KOBO_API_TOKEN' => env('KOBO_API_TOKEN'),
    'PADRON_ASSET_UID' => env('PADRON_ASSET_UID'),
    'PARCELA_ASSET_UID' => env('PARCELA_ASSET_UID'),
    'GEO_ASSET_UID' => env('GEO_ASSET_UID'),
    'DERECHOS_ASSET_UID' => env('DERECHOS_ASSET_UID'),
    'INSPECCION_ASSET_UID' => env('INSPECCION_ASSET_UID'),
    'COMITE_ASSET_UID' => env('COMITE_ASSET_UID'),
    ],

    // 'kobo' => [
    //     'url' => env('KOBO_BASE_URL', 'https://eu.kobotoolbox.org'),
    //     'token' => env('KOBO_API_TOKEN'),
    //     'form_ids' => env('INSPECCION_ASSET_UID')
    // ]

];
