<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('producers', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('_id');

            $table->string('id_productor');
            $table->date('fecha_importacion');
            $table->string('localidad');
            $table->string('municipio');
            $table->string('region');
            $table->string('socio');
            $table->string('grupo_trabajo')->nullable();
            $table->string('curp')->nullable();
            $table->string('rfc')->nullable();
            $table->string('ine')->nullable();
            $table->string('folio_cafetalero')->nullable();
            $table->string('folio_suri')->nullable();
            $table->date('fecha_nacimiento')->nullable();
            $table->string('genero', 20)->nullable();
            $table->string('Estatus_actual')->nullable();
            $table->string('estatus');
            $table->string('categoria_pasada')->nullable();
            $table->date('ingreso');
            $table->date('transicion')->nullable();
            $table->string('celular', 15)->nullable();
            $table->string('email', 20)->nullable();
            $table->string('numero_parcelas');
            $table->boolean('activo')->default(true);
            $table->string('meta_instanceID')->nullable();
            $table->string('meta_rootUuid')->nullable();
            $table->string('meta_instanceName')->nullable();
            $table->string('meta_deprecatedID')->nullable();
            $table->string('__version__')->nullable();
            $table->string('formhub_uuid')->nullable();
            $table->string('_xform_id_string')->nullable();
            $table->string('_uuid')->nullable();
            $table->string('_status')->nullable();
            $table->dateTime('_submission_time')->nullable();
            $table->string('_submitted_by')->nullable();

            //Año para versionamiento de datos
            $table->year('version')->default(date('Y'));


            $table->timestamps();
            //para un busqueda rápida
            $table->unique(['id_productor', 'version']); //Evitar duplicados en el mismo año
            $table->index(['id_productor', 'version']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('producers');
    }
};
