<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productores', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');

            $table->string('productor_dni', 50)->nullable();
            $table->string('productor_id_inspeccion', 50)->nullable();
            $table->string('productor_dni_o', 50)->nullable();
            $table->string('productor_socio', 50)->nullable();
            $table->string('productor_curp', 50)->nullable();
            $table->string('productor_rfc', 50)->nullable();
            $table->string('productor_ine', 50)->nullable();
            $table->string('productor_folio_cafetalero', 50)->nullable();
            $table->string('productor_folio_suri', 50)->nullable();
            $table->string('productor_municipio', 50)->nullable();
            $table->string('productor_localidad', 50)->nullable();
            $table->string('productor_grupo_trabajo', 50)->nullable();
            $table->string('productor_telefono', 50)->nullable();
            $table->string('productor_genero', 10)->nullable();
            $table->date('productor_fecha_nacimiento')->nullable();
            $table->date('productor_fecha_ingreso')->nullable();
            $table->string('productor_estatus', 50)->nullable();
            $table->date('productor_fecha_transicion')->nullable();
            $table->string('productor_baja_productor', 50)->nullable();
            $table->string('productor_tenencia_tierra', 50)->nullable();
            $table->string('productor_titulo_tenencia', 50)->nullable();
            $table->string('productor_papel_tenencia', 50)->nullable();
            $table->string('productor_participa_otra_organizacion', 50)->nullable();
            $table->string('productor_producto_otra_organizazacion', 50)->nullable();
            $table->string('productor_nombre_otra_organizacion_001', 50)->nullable();
            $table->string('productor_familia_participa_otra_organizacion', 50)->nullable();
            $table->string('productor_familia_producto_otra_organizazacion', 50)->nullable();
            $table->string('productor_familia_otra_organizacion', 50)->nullable();
            $table->string('productor_familia_categoria_otra_organizacion', 50)->nullable();

            $table->timestamps();
            
            // $table->foreign('internal_inspection_id')
            //       ->references('id')
            //       ->on('internal_inspections')
            //       ->onDelete('cascade');
                  
            $table->index('productor_dni');
            $table->index('productor_socio');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productores');
    }
};
