<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('areas_generales', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
             $table->string('area_general_tiene_area_autoconsumo', 10)->nullable();
            $table->decimal('area_general_area_autoconsumo', 10, 2)->nullable();
            $table->integer('area_general_autoconsumo_n_parcelas')->nullable();
            $table->string('area_general_autoconsumo_quimicos', 20)->nullable();
            $table->date('area_general_autoconsumo_fecha_quimicos')->nullable();
            $table->decimal('area_general_tiene_area_potrero', 10, 2)->nullable();
            $table->string('area_general_area_potrero', 20)->nullable();
            $table->string('area_general_potrero_n_parcelas', 20)->nullable();
            $table->string('area_general_tiene_area_bosque', 10)->nullable();
            $table->decimal('area_general_area_bosque', 10, 2)->nullable();
            $table->integer('area_general_bosque_n_parcelas')->nullable();
            $table->string('area_general_tiene_area_acahual', 10)->nullable();
            $table->decimal('area_general_area_acahual', 10, 2)->nullable();
            $table->integer('area_general_acahual_n_parcelas')->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('areas_generales');
    }
};
