<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('semilleros_viveros', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            $table->string('semillero_vivero_sem_semillero', 10)->nullable();
            $table->integer('semillero_vivero_sem_numero_semilleros')->nullable();
            $table->string('semillero_vivero_sem_semillas_organicas', 10)->nullable();
            $table->string('semillero_vivero_sem_proveniencia_semillas', 50)->nullable();
            $table->text('semillero_vivero_variedades_semillas')->nullable();
            $table->string('semillero_vivero_sem_control_plagas', 50)->nullable();
            $table->string('semillero_vivero_sem_aplica_producto_quimico', 10)->nullable();
            $table->string('semillero_vivero_sem_producto_quimico', 50)->nullable();
            $table->date('semillero_vivero_sem_fecha_aplicacion_quimico')->nullable();
            $table->string('semillero_vivero_sem_aplica_preparado', 10)->nullable();
            $table->string('semillero_vivero_sem_preparado', 10)->nullable();
            $table->date('semillero_vivero_sem_fecha_aplicacion_preparado')->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('semilleros_viveros');
    }
};
