<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('aboneras', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('internal_inspection_id');
            
            $table->string('abonera_p1_abono_organico', 10)->nullable();
            $table->string('abonera_p1_tipo_abono_organico', 50)->nullable();
            $table->string('abonera_p1_foto_abono_organico', 50)->nullable();
            $table->decimal('abonera_p1_plantas_abono_organico', 50)->nullable();
            $table->decimal('abonera_p1_kilos_litros_abono_composta', 50)->nullable();
            $table->decimal('abonera_p1_kilos_planta_composta', 50)->nullable();
            $table->decimal('abonera_p1_cuantos_litros_lixiviado_lombricomposta', 50)->nullable();
            $table->decimal('abonera_p1_plantas_foliar_lombricomposta', 50)->nullable();
            $table->string('abonera_p1_donde_aplico_composta', 50)->nullable();
            $table->string('abonera_p1_composta_vivero', 10)->nullable();
            $table->integer('abonera_p1_composta_vivero_bolsas')->nullable();
            $table->string('abonera_p1_compra_abono_organico', 10)->nullable();
            $table->string('abonera_p1_compra_abono_cumplimiento', 10)->nullable();
            $table->decimal('abonera_p1_cosecha_abono', 10)->nullable();
            $table->integer('abonera_p1_plantas_abonadas')->nullable();
            $table->string('abonera_p1_aplica_estiercol_crudo', 10)->nullable();
            $table->integer('abonera_p1_estiercol_crudo_plantas')->nullable();
            $table->decimal('abonera_p1_estiercol_crudo_kg', 10)->nullable();
            
            $table->timestamps();
            
            $table->foreign('internal_inspection_id')
                  ->references('id')
                  ->on('internal_inspections')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('aboneras');
    }
};
