<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cosechas_acopio', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('parcela_id');
            
            // Aspecto de las plantas
            $table->string('aspecto_nivel1', 50)->nullable();
            $table->string('aspecto_nivel2', 50)->nullable();
            $table->string('aspecto_nivel3', 50)->nullable();
            
            // Número de plantas
            $table->integer('n_plantas_n1')->nullable();
            $table->integer('n_plantas_n2')->nullable();
            $table->integer('n_plantas_n3')->nullable();
            $table->integer('n_plantas_tot')->nullable();
            
            // Edad y plantillas
            $table->integer('edad_plantas')->nullable();
            $table->string('plantillas', 10)->nullable();
            $table->integer('plantillas_numero')->nullable();
            
            // Producción
            $table->decimal('kg_pergamino_n1', 10, 2)->nullable();
            $table->decimal('kg_pergamino_n2', 10, 2)->nullable();
            $table->decimal('kg_pergamino_n3', 10, 2)->nullable();
            $table->decimal('kg_pergamino_tot', 10, 2)->nullable();
            
            // Campos específicos de parcela 1
            $table->text('condiciones_productivas')->nullable();
            $table->string('entrega_cafe', 100)->nullable();
            $table->string('venta_otro_productor', 10)->nullable();
            $table->string('otro_productor', 100)->nullable();
            $table->date('fecha_cosecha_organico')->nullable();
            
            $table->timestamps();
            
            $table->foreign('parcela_id')
                  ->references('id')
                  ->on('parcelas')
                  ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cosechas_acopio');
    }
};
