@extends('adminlte::page')

@section('title', 'Majomut - Parcelas')

@section('content_header')
    <h1><i class="fas fa-map-marked-alt fa-2x opacity-75"></i>Gestión de Parcelas</h1>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" >{{ $totalParcel }}</h3>
                                <p class="mb-0">Total parcelas</p>
                            </div>
                            <i class="fas fa-users fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h3 class="mb-0" >{{$parcelasActivas}}</h3>
                                <p class="mb-0">Parcelas activas</p>
                            </div>
                            <i class="fas fa-users fa-2x opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="fas fa-cloud-download-alt me-2"></i>
                    Importar desde KoBoToolbox
                </h5>
            </div>
            <div class="card-body">
                <form id="form-importar">
                    @csrf
                    <input type="hidden" name="asset_id" value="{{ config('services.kobotoolbox.PARCELA_ASSET_UID') }}">
                    
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label class="form-label">Año</label>
                            <input type="number" class="form-control" name="year" 
                                value="{{ date('Y') }}" min="2020" max="{{ date('Y') + 1 }}" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Usuario KoBo</label>
                            <input type="text" class="form-control" name="auth_credential" 
                                placeholder="" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Password</label>
                            <div class="input-group">
                                <input type="password" class="form-control" name="second_auth_credential" 
                                    placeholder="Password" required>
                                <button type="button" class="btn btn-outline-secondary" id="toggle-password">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Servidor</label>
                            <select class="form-select" name="server_url" required>
                                <option value="https://eu.kobotoolbox.org">Europa</option>
                                <option value="https://kf.kobotoolbox.org">Global</option>
                                <option value="https://kobo.humanitarianresponse.info">Humanitarian</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">&nbsp;</label>
                            <button type="button" class="btn btn-info w-100" id="btn-verificar">
                                <i class="fas fa-check-circle"></i> Verificar
                            </button>
                        </div>
                    </div>

                    <input type="hidden" name="auth_method" value="basic">

                    <div id="asset-info" class="alert alert-info d-none mb-3">
                        <div id="asset-details"></div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-success btn-lg" id="btn-importar" disabled>
                                <span class="spinner-border spinner-border-sm d-none me-2" role="status"></span>
                                <i class="fas fa-download me-2"></i>
                                Importar Datos
                            </button>
                            <button type="button" class="btn btn-outline-primary btn-lg ms-2" id="btn-actualizar">
                                <i class="fas fa-sync-alt"></i> Actualizar Vista
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div> 

        <div class="card mb-3">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-filter me-2"></i>Filtros</h6>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-2">
                        <label class="form-label">Año</label>
                        <select class="form-select" id="filtro-year" data-index="3">
                            <option value="">Todos</option>
                            <option value="2025">2025</option>
                            <option value="2024">2024</option>
                            <option value="2023">2023</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Región</label>
                        <select class="form-select" id="filtro-region">
                            <option value="">Todas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Municipio</label>
                        <select class="form-select" id="filtro-municipio">
                            <option value="">Todos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estatus</label>
                        <select class="form-select" id="filtro-estatus">
                            <option value="">Todos</option>
                            <option value="Certificado">Certificado</option>
                            <option value="En transición">En transición</option>
                            <option value="Convencional">Convencional</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Estado</label>
                        <select class="form-select" id="filtro-activo">
                            <option value="">Todos</option>
                            <option value="1">Activos</option>
                            <option value="0">Inactivos</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <button class="btn btn-outline-secondary w-100" id="btn-limpiar-filtros">
                            <i class="fas fa-times"></i> Limpiar
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Listado de Productores</h3>
                <div class="card-tools">
                    <div class="btn-group mr-2">
                        <button type="button" class="btn btn-outline-info btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-columns"></i> Columnas a Exportar
                        </button>
                        <div class="dropdown-menu dropdown-menu-right p-3" style="min-width: 300px;" id="column-selector">
                            <h6 class="dropdown-header">Selecciona las columnas a exportar:</h6>
                            <div class="form-group mb-2">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="check-all-columns" checked>
                                    <label class="custom-control-label" for="check-all-columns">Seleccionar Todas</label>
                                </div>
                            </div>
                            <div id="column-checkboxes" style="max-height: 200px; overflow-y: auto;">
                            </div>
                            <div class="dropdown-divider"></div>
                            <button class="btn btn-primary btn-sm btn-block" id="apply-columns">Aplicar Selección</button>
                        </div>
                    </div>
                    
                    <button class="btn btn-outline-primary btn-sm mr-2" id="btn-exportar-excel">
                        <i class="fas fa-file-excel"></i> Exportar Excel
                    </button>
                    <button class="btn btn-outline-success btn-sm mr-2" id="btn-exportar-csv">
                        <i class="fas fa-file-csv"></i> Exportar CSV
                    </button>
                    <button class="btn btn-outline-danger btn-sm mr-2" id="btn-exportar-pdf">
                        <i class="fas fa-file-pdf"></i> Exportar PDF
                    </button>
                    <button class="btn btn-primary btn-sm" id="reload">
                        <i class="fas fa-sync-alt"></i> Recargar
                    </button>
                </div>
            </div>
            <div class="card-body">
                <table id="tabla-productores" class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                        <th>ID</th>
                        <th>ID Kobo (_id)</th>
                        <th>Fecha de importación</th>
                        <th>Fecha de subida</th>
                        <th>Día</th>
                        <th>Dispositivo</th>
                        <th>Usuario</th>
                        <th>Número de teléfono</th>
                        <th>ID Record</th>
                        <th>Código Socio</th>
                        <th>Socio</th>
                        <th>Nombre Parcela</th>
                        <th>N° Parcela</th>
                        <th>ID Parcela</th>
                        <th>Ciclo</th>
                        <th>Superficie</th>
                        <th>Cultivo al Norte</th>
                        <th>Propietario Norte</th>
                        <th>Cultivo al Sur</th>
                        <th>Propietario Sur</th>
                        <th>Cultivo al Este</th>
                        <th>Propietario Este</th>
                        <th>Cultivo al Oeste</th>
                        <th>Propietario Oeste</th>
                        <th>Meta InstanceID</th>
                        <th>Meta RootUuid</th>
                        <th>Meta InstanceName</th>
                        <th>Meta DeprecatedID</th>
                        <th>Versión Form (__version__)</th>
                        <th>Formhub UUID</th>
                        <th>XForm ID String</th>
                        <th>UUID</th>
                        <th>Status</th>
                        <th>Submission Time</th>
                        <th>Submitted By</th>
                        <th>Versión</th>
                        <th>Creado el</th>
                        <th>Actualizado el</th>
                        <th>Acciones</th>
                    </tr>
                    </thead>
                    <tfoot>
                        <tr>
                            <th>ID</th>
                            <th>ID Kobo (_id)</th>
                            <th>Fecha de importación</th>
                            <th>Fecha de subida</th>
                            <th>Día</th>
                            <th>Dispositivo</th>
                            <th>Usuario</th>
                            <th>Número de teléfono</th>
                            <th>ID Record</th>
                            <th>Código Socio</th>
                            <th>Socio</th>
                            <th>Nombre Parcela</th>
                            <th>N° Parcela</th>
                            <th>ID Parcela</th>
                            <th>Ciclo</th>
                            <th>Superficie</th>
                            <th>Cultivo al Norte</th>
                            <th>Propietario Norte</th>
                            <th>Cultivo al Sur</th>
                            <th>Propietario Sur</th>
                            <th>Cultivo al Este</th>
                            <th>Propietario Este</th>
                            <th>Cultivo al Oeste</th>
                            <th>Propietario Oeste</th>
                            <th>Meta InstanceID</th>
                            <th>Meta RootUuid</th>
                            <th>Meta InstanceName</th>
                            <th>Meta DeprecatedID</th>
                            <th>Versión Form (__version__)</th>
                            <th>Formhub UUID</th>
                            <th>XForm ID String</th>
                            <th>UUID</th>
                            <th>Status</th>
                            <th>Submission Time</th>
                            <th>Submitted By</th>
                            <th>Versión</th>
                            <th>Creado el</th>
                            <th>Actualizado el</th>
                            <th>Acciones</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modal-detalles" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-user me-2"></i>Detalles del Productor
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="modal-detalles-content">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

@stop

@section('css')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css">

    <style>
        .card {
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.2s;
        }
        .card:hover {
            transform: translateY(-2px);
        }
        .table th {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        .spinner-custom {
            width: 1rem;
            height: 1rem;
        }
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            max-width: 400px;
        }
    </style>
@stop

@section('js')
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>


    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>


    <script>
        $(document).ready(function() {
            let tabla;
            let selectedColumns = [];

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // Inicializar selector de columnas
            function initColumnSelector() {
                const container = $('#column-checkboxes');
                container.empty();

                const exportableColumns = [
                    { index: 1, title: 'ID Kobo' },
                    { index: 2, title: 'Fecha Importación' },
                    { index: 3, title: 'Fecha Subida' },
                    { index: 4, title: 'Día' },
                    { index: 5, title: 'Dispositivo' },
                    { index: 6, title: 'Usuario' },
                    { index: 7, title: 'Número Teléfono' },
                    { index: 8, title: 'ID Record' },
                    { index: 9, title: 'Código Socio' },
                    { index: 10, title: 'Socio' },
                    { index: 11, title: 'Nombre Parcela' },
                    { index: 12, title: 'N° Parcela' },
                    { index: 13, title: 'ID Parcela' },
                    { index: 14, title: 'Ciclo' },
                    { index: 15, title: 'Superficie' },
                    { index: 16, title: 'Cultivo Norte' },
                    { index: 17, title: 'Propietario Norte' },
                    { index: 18, title: 'Cultivo Sur' },
                    { index: 19, title: 'Propietario Sur' },
                    { index: 20, title: 'Cultivo Este' },
                    { index: 21, title: 'Propietario Este' },
                    { index: 22, title: 'Cultivo Oeste' },
                    { index: 23, title: 'Propietario Oeste' },
                    { index: 24, title: 'Meta InstanceID' },
                    { index: 25, title: 'Meta RootUuid' },
                    { index: 26, title: 'Meta InstanceName' },
                    { index: 27, title: 'Meta DeprecatedID' },
                    { index: 28, title: 'Versión Form' },
                    { index: 29, title: 'Formhub UUID' },
                    { index: 30, title: 'XForm ID String' },
                    { index: 31, title: 'UUID' },
                    { index: 32, title: 'Status' },
                    { index: 33, title: 'Submission Time' },
                    { index: 34, title: 'Submitted By' },
                    { index: 35, title: 'Versión' }
                ];

                exportableColumns.forEach((col) => {
                    const colId = `col-${col.index}`;
                    container.append(`
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input column-checkbox" 
                                id="${colId}" data-index="${col.index}" checked>
                            <label class="custom-control-label" for="${colId}">${col.title}</label>
                        </div>
                    `);
                    selectedColumns.push(col.index);
                });

                $('#column-selector').on('click', function(e) {
                    e.stopPropagation();
                });

                $('#check-all-columns').on('change', function(e) {
                    e.stopPropagation();
                    const isChecked = $(this).is(':checked');
                    $('.column-checkbox').prop('checked', isChecked);
                    selectedColumns = isChecked ? exportableColumns.map(c => c.index) : [];
                });

                $('.column-checkbox').on('change', function(e) {
                    e.stopPropagation();
                    const index = parseInt($(this).data('index'));
                    const isChecked = $(this).is(':checked');
                    
                    if (isChecked) {
                        if (!selectedColumns.includes(index)) {
                            selectedColumns.push(index);
                        }
                    } else {
                        selectedColumns = selectedColumns.filter(i => i !== index);
                    }
                    
                    $('#check-all-columns').prop('checked', 
                        selectedColumns.length === exportableColumns.length
                    );
                });

                $('#apply-columns').on('click', function(e) {
                    e.stopPropagation();
                    $('.dropdown-toggle').dropdown('toggle');
                });
            }

            // Inicializar DataTable
            function initDataTable() {
                tabla = $('#tabla-productores').DataTable({
                    processing: true,
                    scrollX: true,
                    serverSide: false,
                    dom: 'Blfrtip',
                    ajax: {
                        url: "{{ route('parcelas.datatables') }}",
                        dataSrc: ""
                    },
                    columns: [
                        { data: 'id', title: 'ID', visible: false },
                        { data: '_id', title: 'ID Kobo' },
                        { data: 'created_at', title: 'Fecha Importación' },
                        { data: 'starttime', title: 'Fecha Subida' },
                        { data: 'today', title: 'Día' },
                        { data: 'deviceid', title: 'Dispositivo' },
                        { data: 'usuario', title: 'Usuario' },
                        { data: 'numero_telefono', title: 'Número Teléfono' },
                        { data: 'id_record', title: 'ID Record' },
                        { data: 'codigo_socio', title: 'Código Socio' },
                        { data: 'socio', title: 'Socio' },
                        { data: 'nombre_parcela', title: 'Nombre Parcela' },
                        { data: 'n_parcela', title: 'N° Parcela' },
                        { data: 'id_parcela', title: 'ID Parcela' },
                        { data: 'ciclo', title: 'Ciclo' },
                        { data: 'superficie', title: 'Superficie' },
                        { data: 'norte', title: 'Cultivo Norte' },
                        { data: 'norte_propietario', title: 'Propietario Norte' },
                        { data: 'sur', title: 'Cultivo Sur' },
                        { data: 'sur_propietario', title: 'Propietario Sur' },
                        { data: 'este', title: 'Cultivo Este' },
                        { data: 'este_propietario', title: 'Propietario Este' },
                        { data: 'oeste', title: 'Cultivo Oeste' },
                        { data: 'oeste_propietario', title: 'Propietario Oeste' },
                        { data: 'meta_instanceID', title: 'Meta InstanceID' },
                        { data: 'meta_rootUuid', title: 'Meta RootUuid' },
                        { data: 'meta_instanceName', title: 'Meta InstanceName' },
                        { data: 'meta_deprecatedID', title: 'Meta DeprecatedID' },
                        { data: '__version__', title: 'Versión Form' },
                        { data: 'formhub_uuid', title: 'Formhub UUID' },
                        { data: '_xform_id_string', title: 'XForm ID String' },
                        { data: '_uuid', title: 'UUID' },
                        { data: '_status', title: 'Status' },
                        { data: '_submission_time', title: 'Submission Time' },
                        { data: '_submitted_by', title: 'Submitted By' },
                        { data: 'version', title: 'Versión' },
                        { data: 'created_at', title: 'Creado el' },
                        { data: 'updated_at', title: 'Actualizado el' },
                        {
                            data: null,
                            title: 'Acciones',
                            orderable: false,
                            exportable: false,
                            render: function (data, type, row) {
                                return `
                                    <div class="btn-group" role="group">
                                        <button class="btn btn-sm btn-primary btn-editar" data-id="${row.id}" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-info btn-ver" data-id="${row.id}" title="Ver">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger btn-eliminar" data-id="${row.id}" title="Eliminar">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                `;
                            }
                        }
                    ],
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            text: 'Excel',
                            className: 'd-none',
                            filename: function() {
                                return 'parcelas_export_' + new Date().toISOString().split('T')[0];
                            },
                            exportOptions: {
                                columns: function(idx, data, node) {
                                    return selectedColumns.includes(idx);
                                },
                                orthogonal: 'export',
                                modifier: {
                                    search: 'applied',
                                    order: 'applied'
                                }
                            }
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            className: 'd-none',
                            filename: function() {
                                return 'parcelas_export_' + new Date().toISOString().split('T')[0];
                            },
                            exportOptions: {
                                columns: function(idx, data, node) {
                                    return selectedColumns.includes(idx);
                                },
                                orthogonal: 'export',
                                modifier: {
                                    search: 'applied',
                                    order: 'applied'
                                }
                            }
                        },
                        {
                            extend: 'pdfHtml5',
                            text: 'PDF',
                            className: 'd-none',
                            orientation: 'landscape',
                            pageSize: 'LEGAL',
                            filename: function() {
                                return 'parcelas_export_' + new Date().toISOString().split('T')[0];
                            },
                            exportOptions: {
                                columns: function(idx, data, node) {
                                    return selectedColumns.includes(idx);
                                },
                                orthogonal: 'export',
                                modifier: {
                                    search: 'applied',
                                    order: 'applied'
                                }
                            },
                            customize: function(doc) {
                                doc.content[1].table.widths = Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                                doc.styles.tableHeader.fillColor = '#2980b9';
                                doc.styles.tableHeader.color = 'white';
                            }
                        }
                    ],
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json'
                    }
                });
            }

            function showNotification(message, type) {
                const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
                const icon = type === 'success' ? 'fas fa-check-circle' : 'fas fa-exclamation-triangle';
                
                const notification = $(`
                    <div class="alert ${alertClass} alert-dismissible fade show notification" style="position: fixed; top: 20px; right: 20px; z-index: 9999;">
                        <i class="${icon} me-2"></i>
                        ${message}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                `);
                
                $('body').append(notification);
                setTimeout(() => notification.alert('close'), 5000);
            }

            
            $('#btn-exportar-excel').on('click', function() {
                if (selectedColumns.length === 0) {
                    alert('Por favor, selecciona al menos una columna para exportar.');
                    return;
                }
                tabla.button(0).trigger();
                showNotification('Exportando a Excel...', 'success');
            });

            $('#btn-exportar-csv').on('click', function() {
                if (selectedColumns.length === 0) {
                    alert('Por favor, selecciona al menos una columna para exportar.');
                    return;
                }
                tabla.button(1).trigger();
                showNotification('Exportando a CSV...', 'success');
            });

            $('#btn-exportar-pdf').on('click', function() {
                if (selectedColumns.length === 0) {
                    alert('Por favor, selecciona al menos una columna para exportar.');
                    return;
                }
                tabla.button(2).trigger();
                showNotification('Exportando a PDF...', 'success');
            });

            
            $('#toggle-password').on('click', function() {
                const input = $('input[name="second_auth_credential"]');
                const icon = $(this).find('i');
                
                if (input.attr('type') === 'password') {
                    input.attr('type', 'text');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                } else {
                    input.attr('type', 'password');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                }
            });

            
            $('#btn-verificar').on('click', function() {
                const formData = {
                    auth_method: 'basic',
                    auth_credential: $('input[name="auth_credential"]').val(),
                    second_auth_credential: $('input[name="second_auth_credential"]').val(),
                    asset_id: $('input[name="asset_id"]').val(),
                    server_url: $('select[name="server_url"]').val(),
                    year: $('input[name="year"]').val()
                };

                if (!formData.auth_credential || !formData.second_auth_credential) {
                    showNotification('Por favor completa todos los campos requeridos', 'error');
                    return;
                }

                const btn = $(this);
                btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Verificando...');

                $.post('/parcelas/info-asset', formData)
                    .done(function(response) {
                        if (response.success) {
                            $('#asset-info').removeClass('d-none');
                            $('#asset-details').html(`
                                <strong>Asset:</strong> ${response.name}<br>
                                <strong>Registros:</strong> ${response.deployment_count}<br>
                                <strong>Modificado:</strong> ${response.date_modified ? new Date(response.date_modified).toLocaleString('es-ES') : 'N/A'}
                            `);
                            $('#btn-importar').prop('disabled', false);
                            showNotification('Credenciales verificadas correctamente', 'success');
                        } else {
                            $('#asset-info').addClass('d-none');
                            showNotification('Error: ' + response.message, 'error');
                        }
                    })
                    .fail(function(xhr) {
                        $('#asset-info').addClass('d-none');
                        const message = xhr.responseJSON?.message || 'Error desconocido';
                        showNotification('Error al verificar: ' + message, 'error');
                    })
                    .always(function() {
                        btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> Verificar');
                    });
            });

            // Importar datos
            $('#form-importar').on('submit', function(e) {
                e.preventDefault();
                
                const formData = {
                    year: $('input[name="year"]').val(),
                    auth_method: 'basic',
                    auth_credential: $('input[name="auth_credential"]').val(),
                    second_auth_credential: $('input[name="second_auth_credential"]').val(),
                    asset_id: $('input[name="asset_id"]').val(),
                    server_url: $('select[name="server_url"]').val()
                };

                const btn = $('#btn-importar');
                const spinner = btn.find('.spinner-border');
                
                btn.prop('disabled', true);
                spinner.removeClass('d-none');
                btn.find('i.fa-download').addClass('d-none');
                
                $.post('/parcelas/importar-kobo', formData)
                    .done(function(response) {
                        if (response.success) {
                            showNotification(`Importación exitosa: ${response.total} registros importados`, 'success');
                            setTimeout(() => location.reload(), 2000);
                        } else {
                            showNotification('Error: ' + response.message, 'error');
                        }
                    })
                    .fail(function(xhr) {
                        const message = xhr.responseJSON?.message || 'Error desconocido';
                        showNotification('Error en la importación: ' + message, 'error');
                    })
                    .always(function() {
                        btn.prop('disabled', true);
                        spinner.addClass('d-none');
                        btn.find('i.fa-download').removeClass('d-none');
                    });
            });

            // Filtros
            $('#filtro-year').on('change', function() {
                tabla.column(2).search(this.value).draw();
            });

            $('#filtro-region').on('change', function() {
                tabla.column(5).search(this.value).draw();
            });

            $('#filtro-municipio').on('change', function() {
                tabla.column(4).search(this.value).draw();
            });

            $('#btn-limpiar-filtros').on('click', function() {
                $('#filtro-year, #filtro-region, #filtro-municipio, #filtro-estatus, #filtro-activo').val('');
                if (tabla) {
                    tabla.search('').columns().search('').draw();
                }
            });

            $('#reload, #btn-actualizar').on('click', function() {
                if (tabla) {
                    tabla.ajax.reload();
                    $(this).find('i').addClass('fa-spin');
                    setTimeout(() => {
                        $(this).find('i').removeClass('fa-spin');
                    }, 1000);
                }
            });

            // Inicializar
            initColumnSelector();
            initDataTable();
        });
    </script>
@stop