<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Portal SIC</title>

        <link href="{{ asset('img/favicon.ico') }}" rel="icon">

        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />
        <link rel="preconnect" href="https://fonts.gstatic.com">
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@200;400&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

        <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" rel="stylesheet">

        <link href="{{ asset('lib/owlcarousel/assets/owl.carousel.min.css') }}" rel="stylesheet">
        <link href="{{ asset('lib/tempusdominus/css/tempusdominus-bootstrap-4.min.css') }}" rel="stylesheet">

        <link href="{{ asset('css/style.min.css') }}" rel="stylesheet">

        <style>
            .nav-bar {
                position: relative;
                width: 100%;
                z-index: 1000;
            }
            
            .navbar-dark .navbar-nav .nav-link {
                position: relative;
                padding: 10px 15px;
                font-size: 16px;
                font-weight: 500;
                color: #ffffff !important;
                text-transform: uppercase;
                outline: none;
            }
            
            .navbar-dark .navbar-nav .nav-link:hover,
            .navbar-dark .navbar-nav .nav-link.active {
                color: #D19C97 !important;
            }
            
            .navbar-dark .navbar-brand h1 {
                color: #ffffff;
                font-size: 36px;
                font-weight: 700;
                letter-spacing: 2px;
            }
            
            .navbar-dark .navbar-toggler {
                border-color: rgba(255, 255, 255, 0.5);
            }
            
            .dropdown-menu {
                border: none;
                border-radius: 0;
                background: #121518;
            }
            
            .dropdown-item {
                color: #ffffff;
                padding: 8px 20px;
            }
            
            .dropdown-item:hover {
                color: #D19C97;
                background: transparent;
            }
        </style>

        @vite('resources/css/app.css')
    </head>
    <body class="bg-[#FDFDFC] dark:bg-[#0a0a0a] text-[#1b1b18]">
        <div class="container-fluid p-0 nav-bar">
            <nav class="navbar navbar-expand-lg bg-none navbar-dark py-3">
                <a href="{{ url('/') }}" class="navbar-brand px-lg-4 m-0">
                    <h1 class="m-0 display-4 text-uppercase text-white">SIC MAJOMUT</h1>
                </a>
                <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                    <div class="navbar-nav ml-auto p-4">
                        <a href="{{ url('/') }}" class="nav-item nav-link {{ request()->is('/') ? 'active' : '' }}">Inicio</a>
                        <a href="{{ url('/about') }}" class="nav-item nav-link {{ request()->is('about') ? 'active' : '' }}">Nosotros</a>
                        <a href="{{ url('/services') }}" class="nav-item nav-link {{ request()->is('services') ? 'active' : '' }}">Servicios</a>
                        <a href="{{ url('/products') }}" class="nav-item nav-link {{ request()->is('products') ? 'active' : '' }}">Productos</a>
                        
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">Más</a>
                            <div class="dropdown-menu text-capitalize">
                                <a href="{{ url('/gallery') }}" class="dropdown-item">Galería</a>
                                <a href="{{ url('/testimonials') }}" class="dropdown-item">Testimonios</a>
                            </div>
                        </div>
                        
                        <a href="{{ url('/contact') }}" class="nav-item nav-link {{ request()->is('contact') ? 'active' : '' }}">Contacto</a>
                        
                        @auth
                            <a href="{{ url('/dashboard') }}" class="nav-item nav-link ml-3 {{ request()->is('dashboard') ? 'active' : '' }}">
                                <i class="fas fa-user-circle mr-1"></i> Dashboard
                            </a>
                        @else
                            <a href="{{ route('login') }}" class="nav-item nav-link ml-3 {{ request()->is('login') ? 'active' : '' }}">
                                <i class="fas fa-sign-in-alt mr-1"></i> Ingresar
                            </a>
                            
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}" class="nav-item nav-link ml-3 {{ request()->is('register') ? 'active' : '' }}">
                                    <i class="fas fa-user-plus mr-1"></i> Registrarse
                                </a>
                            @endif
                        @endauth
                    </div>
                </div>
            </nav>
        </div>
        
        <div class="container-fluid p-0 mb-5">
            <div id="blog-carousel" class="carousel slide overlay-bottom" data-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <img class="w-100" src="{{ asset('img/carousel-1.jpg') }}" alt="Image">
                        <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                            <h2 class="text-primary font-weight-medium m-0">Unión de productores orgánicos</h2>
                            <h1 class="display-1 text-white m-0">SIC MAJOMUT</h1>
                            <h2 class="text-white m-0">Desde 1981</h2>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <img class="w-100" src="{{ asset('img/carousel-2.jpg') }}" alt="Image">
                        <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                            <h2 class="text-primary font-weight-medium m-0">Unión de productores orgánicos</h2>
                            <h1 class="display-1 text-white m-0">SIC MAJOMUT</h1>
                            <h2 class="text-white m-0">Desde 1981</h2>
                        </div>
                    </div>
                </div>
                <a class="carousel-control-prev" href="#blog-carousel" data-slide="prev">
                    <span class="carousel-control-prev-icon"></span>
                </a>
                <a class="carousel-control-next" href="#blog-carousel" data-slide="next">
                    <span class="carousel-control-next-icon"></span>
                </a>
            </div>
        </div>

        <div class="flex items-center justify-center w-full transition-opacity opacity-100 duration-750 lg:grow starting:opacity-0">
            <main class="flex max-w-[335px] w-full flex-col-reverse lg:max-w-4xl lg:flex-row">
            </main>
        </div>

        <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js"></script>
        
        <script src="{{ asset('lib/easing/easing.min.js') }}"></script>
        <script src="{{ asset('lib/waypoints/waypoints.min.js') }}"></script>
        <script src="{{ asset('lib/owlcarousel/owl.carousel.min.js') }}"></script>
        <script src="{{ asset('lib/tempusdominus/js/moment.min.js') }}"></script>
        <script src="{{ asset('lib/tempusdominus/js/moment-timezone.min.js') }}"></script>
        <script src="{{ asset('lib/tempusdominus/js/tempusdominus-bootstrap-4.min.js') }}"></script>

        <script src="{{ asset('js/main.js') }}"></script>

        @vite('resources/js/app.js')
    </body>
</html>