<?php

use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\EvaluationCommitteeController;
use App\Http\Controllers\GeoreferencingController;
use App\Http\Controllers\HumanRightsAndDueDiligenceController;
use App\Http\Controllers\InternalInspectionController;
use App\Http\Controllers\ParcelController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\InspeccionController;
use App\Http\Controllers\PlotController;
use App\Http\Controllers\ProducerController;
use App\Http\Controllers\ProfileController;
use App\Models\CoffeeParcelRegistry;
use App\Models\Georeferencing;
use App\Models\InternalInspection;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
})->name('home');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');


// routes/web.php PRODUCTORES
Route::prefix('productores')->name('productores.')->middleware(['auth', 'verified'])->group(function () {
    //Rutas Principales
    Route::get('/', [ProducerController::class, 'index'])->name('index');
    Route::get('productores/{id}',[ProducerController::class, 'show']);
    //API para Datatables
    Route::get('/datatables', [ProducerController::class, 'dataTables'])->name('datatables');
    //Importación y exportacion
    Route::post('/importar-kobo', [ProducerController::class, 'importarKobo'])->name('importar-kobo');
    Route::get('/exportar', [ProducerController::class, 'exportar'])->name('exportar');
    //Información y estadisticas
    Route::get('/estadisticas', [ProducerController::class, 'estadisticas'])->name('estadisticas');
    Route::post('/info-asset', [ProducerController::class, 'infoAsset'])->name('info-asset');
    //Sincronización
    Route::post('/sincronizar', [ProducerController::class, 'sincronizarAutomatico'])->name('sincronizar');
    //Eliminar información
    Route::delete('/eliminar',[ProducerController::class, 'destroy'])->name('eliminar');
});



//ROUTER PARCELAS
Route::prefix('parcelas')->name('parcelas.')->middleware(['auth', 'verified'])->group(function () {
    Route::get('/', [ParcelController::class, 'index'])->name('index');
    Route::get('parcelas/{id}',[ParcelController::class, 'show']);
    //API para datatables
    Route::get('/datatables', [ParcelController::class, 'dataTables'])->name('datatables');
    // Importación y exportacion
    Route::post('/importar-kobo',[ParcelController::class, 'importarKobo'])->name('importar-kobo');
    Route::get('/exportar', [ParcelController::class, 'exportar'])->name('exportar');
    // Información y estadisticas
    Route::post('/info-asset', [ParcelController::class, 'infoAsset'])->name('info-asset');
    //Sincronizar
    Route::post('/sincronizar', [ParcelController::class, 'sincronizarAutomatico'])->name('sincronizar');
})->middleware('auth', 'verified');

//GEOREFERENCIACION
Route::prefix('georeferenciacion')->name('georeferenciacion.')->group(function(){
    Route::get('/',[GeoreferencingController::class, 'index'])->name('index'); //vista principal del modulo

    Route::get('/mapa',[GeoreferencingController::class, 'indexmap'])->name('indexmap'); //vista del mapa con poligonos

    // API para obtener polígonos en formato GeoJSON
    Route::get('/poligonos', [GeoreferencingController::class, 'getPoligonosformato'])->name('getPoligonosformato'); //obtener poligonos en Geojson
    
    // Vista del mapa con formato (búsqueda de parcelas)
    Route::get('/formatomapa', [GeoreferencingController::class, 'mapaformato'])->name('mapaformato'); //vista del formato de mapa
    
    // Actualizar ubicación de parcela
    Route::post('/update-location', [GeoreferencingController::class, 'updateLocation'])->name('updateLocation');

    Route::get('georeferenciacion/{id}',[GeoreferencingController::class, 'show']);
    //API para datatables
    Route::get('/datatables', [GeoreferencingController::class, 'dataTables'])->name('datatables');
    Route::get('/datatablesactivos', [GeoreferencingController::class, 'datatablesActivos'])->name('datatablesactivos');
    //Importación y exportación
    Route::post('/importar-kobo',[GeoreferencingController::class,'importarKobo'])->name('importar-kobo');
    Route::get('/exportar', [GeoreferencingController::class, 'exportar'])->name('exportar');
    //Notificaciones
    Route::post('/info-asset',[GeoreferencingController::class, 'infoAsset'])->name('info-asset');
    //Sincronizar
    Route::post('/sincronizar', [GeoreferencingController::class, 'sincronizarAutomatico'])->name('sincronizar');
    //Mapa genera
    Route::get('/api/poligonos', [GeoreferencingController::class,'getPoligonos'])->name('getPoligonos');
    //Tabla de poligonos activos en base a padron
    Route::get('/activos', [GeoreferencingController::class,'getactivos'])->name('getactivos');
    //Modal de productores sin poligonos
    Route::get('/reportes/productores-sin-poligono', [GeoreferencingController::class,'productoresSinPoligono'])->name('productoresSinPoligono');
    //Parcelas sin poligonos
    Route::get('sinpoligono', [GeoreferencingController::class, 'getParcelasSinPoligono'])->name('sinpoligono');
    //Subir puntos de deforestación
    Route::post('/mapa/subir', [GeoreferencingController::class, 'subirmapa'])->name('subir.mapa');

})->middleware(['auth', 'verified']);

// DERECHOS HUMANOS
Route::prefix('derechoshumanos')->name('derechoshumanos.')->middleware(['auth', 'verified'])->group(function () {
    // Vista principal
    Route::get('/', [HumanRightsAndDueDiligenceController::class, 'index'])->name('index');
    
    // DataTables - Para la tabla con AJAX
    Route::get('/datatables', [HumanRightsAndDueDiligenceController::class, 'datatables'])->name('datatables');
    
    // Importación y exportación
    Route::post('/importar-kobo', [HumanRightsAndDueDiligenceController::class, 'importarKobo'])->name('importar-kobo');
    Route::post('/debug-estructura', [HumanRightsAndDueDiligenceController::class, 'debugEstructura'])->name('debug-estructura');
    Route::get('/exportar', [HumanRightsAndDueDiligenceController::class, 'exportar'])->name('exportar');
    
    // Información y estadísticas
    Route::post('/info-asset', [HumanRightsAndDueDiligenceController::class, 'infoAsset'])->name('info-asset');
    
    // Sincronización
    Route::post('/sincronizar', [HumanRightsAndDueDiligenceController::class, 'sincronizarAutomatico'])->name('sincronizar');
});

//INSPECCION INTERNA
// Route::prefix('Inspeccio')->name('Inspeccio.')->group(function(){
//     Route::get('/',[InternalInspectionController::class, 'index'])->name('index');
//     //Importacion y exportacion
//     Route::post('/importar-kobo',[InternalInspectionController::class, 'importarKobo'])->name('importar-kobo');
//     Route::get('/exportar',[InternalInspectionController::class, 'exportar'])->name('exportar');
//     Route::get('/datatables', [InternalInspectionController::class, 'dataTables'])->name('datatables');

//     //Información de alertas
//     Route::post('info-asset', [InternalInspectionController::class,'infoAsset'])->name('info-asset');
//     //Sincronizar
//     Route::post('/sincronizar',[InternalInspectionController::class,'sincronizarAutomatico'])->name('sincronizar');
// })->middleware(['auth', 'verified'])->name('dashboard');

//COMITE DE EVALUACIÓN
Route::prefix('Comite')->name('Comite.')->group(function(){
    Route::get('/',[EvaluationCommitteeController::class, 'index'])->name('index');
})->middleware(['auth', 'verified'])->name('dashboard');

//Inspeccion interna funcional
Route::prefix('Inspeccio')->group(function () {

    



    // Vista principal
    Route::get('/', [InspeccionController::class, 'index'])->name('inspecciones.index');
    
    // Verificación de asset de KoboToolbox
    Route::post('/info-asset', [InspeccionController::class, 'getAssetInfo'])->name('inspecciones.info-asset');

    Route::get('/vista-individual', [InspeccionController::class, 'vistaIndividual'])->name('inspeccion.vista');
    
    // APIs para la vista individual
    Route::get('/productores', [InspeccionController::class, 'getProductores']);
    Route::get('/fechas/{dni}', [InspeccionController::class, 'getFechasInspeccion']);
    Route::get('/ver/{id}', [InspeccionController::class, 'verInspeccion']);
    Route::get('/exportar-pdf/{id}', [InspeccionController::class, 'exportarPDF']);
    
    // Importación desde KoboToolbox
    Route::post('/importar-kobo', [InspeccionController::class, 'importarKobo'])->name('inspecciones.importar');
    
    // Obtener datos para DataTable
    Route::get('/datos', [InspeccionController::class, 'getData'])->name('inspecciones.datos');
    
    // Obtener detalles de una inspección específica (NUEVO)
    Route::get('/detalles/{koboId}', [InspeccionController::class, 'getDetalles'])->name('inspecciones.detalles');
    
    // Exportar datos
    Route::get('/exportar', [InspeccionController::class, 'exportar'])->name('inspecciones.exportar');
});


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/permisos/create', [PermissionController::class, 'create'])->name('permisos.create');
});

Route::middleware('guaest')->group(function(){
    Route::get('forgot-password', [PasswordResetLinkController::class, 'create'])->name('password.request');

    Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])
                ->name('password.email');

    // Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])
    //             ->name('password.reset');

    // Route::post('reset-password', [NewPasswordController::class, 'store'])
    //             ->name('password.store');
});

require __DIR__.'/auth.php';
